package csbase.client.util.gui.log.actions;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

import javax.swing.JComponent;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;
import csbase.logic.ClientProjectFile;

/**
 * Exporta o arquivo de log.
 * 
 * @author Tecgraf
 */
public class ExportLogAction extends AbstractLogFileAction {

  /**
   * Guarda o ltimo diretrio usado na exportao.
   */
  private ClientLocalFile lastSelectedDir;

  /**
   * Construtor.
   * 
   * @param logPanel Painel de log que detm o boto dessa ao.
   */
  public ExportLogAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_EXPORT_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {

    String title = LNG.get("ExportLogAction.chooser.title");
    Collection<String> fileCodes = new ArrayList<String>();
    fileCodes.add("TEXT");
    fileCodes.add("LOG");
    final ClientLocalFile localFile =
      ClientLocalFileChooserUtil.browseSingleFileInSaveMode(getLogPanel()
        .getOwner(), fileCodes, "LOG", title, true, lastSelectedDir);

    if (localFile == null) {
      return;
    }
    else {
      lastSelectedDir = localFile.getParent();
    }

    // Exporta o arquivo de log para o sistema de arquivos local.
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      protected void performTask() throws Exception {
        exportAsStream(localFile);
      }
    };

    // Executa a task para exportar o arquivo de log.
    Window window = getLogPanel().getOwner();
    String message = LNG.get("ExportLogAction.export.log");
    boolean result = task.execute(window, title, message);
    if (result) {
      message =
        LNG.get("ExportLogAction.export.log.success",
          new Object[] { localFile.getStringPath() });
      StandardDialogs.showInfoDialog(window, title, message);
    }
  }

  /**
   * Exporta o arquivo de log como stream.
   * 
   * @param localFile Arquivo local que conter o arquivo de log.
   * @throws Exception em caso de erro na exportao.
   */
  private void exportAsStream(final ClientLocalFile localFile) throws Exception {
    final int bufferSize = 48 * 1024;
    final ClientProjectFile remoteFile = getLogPanel().getFile();
    if (remoteFile == null || !remoteFile.exists()) {
      return;
    }
    final InputStream prjStream = remoteFile.getInputStream();
    final BufferedInputStream in = new BufferedInputStream(prjStream);
    final OutputStream fileStream = localFile.getOutputStream();
    BufferedOutputStream out = new BufferedOutputStream(fileStream);
    byte[] buffer = new byte[bufferSize];
    int len = 0;
    while ((len = in.read(buffer)) > 0) {
      out.write(buffer, 0, len);
    }
    out.flush();
    out.close();
    in.close();
  }

}