package csbase.client.util.table;

import csbase.client.util.table.TextFieldCellView.HorizontalAlignment;

/**
 * Fbrica de Clulas de Texto: cria clulas de texto.
 */
public final class TextFieldCellViewFactory implements CellViewFactory {

  /**
   * O conversor.
   */
  private Converter converter;

  /**
   * O alinhamento horizontal.
   */
  private HorizontalAlignment horizontalAlignment;

  /**
   * Os validadores.
   */
  private Validator[] validators;

  /**
   * Cria uma fbrica de clulas de texto.
   * 
   * @param validators Os validadores.
   */
  public TextFieldCellViewFactory(Validator... validators) {
    this(null, null, validators);
  }

  /**
   * Cria uma fbrica de clulas de texto.
   * 
   * @param horizontalAlignment O alinhamento horizonal (Aceita {@code null}).
   * @param converter O conversor (Aceita {@code null}).
   * @param validators Os validadores.
   */
  public TextFieldCellViewFactory(HorizontalAlignment horizontalAlignment,
    Converter converter, Validator... validators) {
    this.horizontalAlignment = horizontalAlignment;
    this.converter = converter;
    this.validators = new Validator[validators.length];
    for (int i = 0; i < validators.length; i++) {
      Validator validator = validators[i];
      this.validators[i] = validator;
    }
  }
  
  public CellView create() {
    return new TextFieldCellView(horizontalAlignment, converter, validators);
  }
}
