/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.core;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.util.StandardErrorDialogs;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.core.IContext;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class CSDKEnvironment
implements ICSDKEnvironment {
    private final Map<Class<? extends IContext>, IContext> contexts;

    public CSDKEnvironment(Map<Class<? extends IContext>, IContext> contexts) {
        this.contexts = contexts;
    }

    public void finishApplication() {
        ApplicationType app;
        ApplicationManager manager = ApplicationManager.getInstance();
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        if (appContext != null && (app = manager.getApplicationInstance(appContext.getInstanceId())) != null) {
            app.closeApplication();
        }
    }

    public <T extends IContext> T getContext(Class<T> contextClass) {
        if (contextClass == null) {
            return null;
        }
        IContext context = this.contexts.get(contextClass);
        if (context != null) {
            try {
                IContext t = (IContext)contextClass.cast(context);
                if (!context.isActive()) {
                    t.onContextActivate();
                }
                return (T)t;
            }
            catch (Exception e) {
                this.handleException(e, null);
            }
        }
        return null;
    }

    public void handleException(Exception error, Window parent) {
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        String title = null;
        if (appContext != null) {
            title = appContext.getApplicationName();
        }
        StandardErrorDialogs.showExceptionDialog(parent, title, error);
    }

    public void cleanup() {
        for (IContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.onContextDeactivate();
        }
        this.contexts.clear();
    }

    public Locale getLocale() {
        return LNG.getLocale();
    }

    public Charset getServerCharset() {
        return Client.getInstance().getSystemDefaultCharset();
    }

    public Charset getCharset() {
        return Client.getInstance().getClientHostCharset();
    }
}

