/*
 * Decompiled with CFR 0.152.
 */
package csbase.command;

import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.FileParameterValue;
import csbase.server.Server;
import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import csbase.server.plugin.service.commandpersistenceservice.ICommandStatusListener;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.projectservice.ProjectService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import tecgraf.javautils.core.io.FileUtils;

public class DataProvenanceHandler
implements ICommandStatusListener {
    private CommandPersistenceService commandPersistenceService;
    private ProjectService projectService;

    public DataProvenanceHandler(IServiceManager serviceManager) {
        this.commandPersistenceService = (CommandPersistenceService)serviceManager.getService("CommandPersistenceService");
        this.projectService = (ProjectService)serviceManager.getService("ProjectService");
    }

    public void statusChanged(ICommandInfo commandInfo) {
        AlgorithmConfigurator configurator = this.commandPersistenceService.readAlgorithmConfigurator((Object)commandInfo.getProjectId(), commandInfo.getCommandId());
        if (commandInfo.getStatus().equals((Object)ICommandInfo.CommandStatus.UPLOADING)) {
            Set inputFileCollection = configurator.getInputFiles();
            Set inputDirColletion = configurator.getInputDirectories();
            TreeSet<FileParameterValue> inputs = new TreeSet<FileParameterValue>();
            inputs.addAll(inputDirColletion);
            inputs.addAll(inputFileCollection);
            this.createCommandInputHistory(commandInfo, inputs);
            return;
        }
        if (commandInfo.getStatus().equals((Object)ICommandInfo.CommandStatus.FINISHED) && this.projectService.existsProject((Object)commandInfo.getProjectId())) {
            Set outputFileCollection = configurator.getOutputFiles();
            Set outputDirColletion = configurator.getOutputDirectories();
            TreeSet<FileParameterValue> outputs = new TreeSet<FileParameterValue>();
            outputs.addAll(outputDirColletion);
            outputs.addAll(outputFileCollection);
            this.createCommandOutputHistory(commandInfo, outputs);
        }
    }

    private void createCommandInputHistory(ICommandInfo commandInfo, Collection<FileParameterValue> inputFileCollection) {
        String projectId = commandInfo.getProjectId();
        String commandId = FileUtils.fixDirectoryName((String)commandInfo.getCommandId());
        String[] filesDir = new String[]{".cmds", commandId, "FILES"};
        this.projectService.createDirectory((Object)projectId, filesDir);
        String[] historyPath = new String[]{".cmds", commandId, "FILES", "INPUT_FILES"};
        this.projectService.createDirectory((Object)projectId, historyPath);
        this.createCommandHistory(commandInfo, inputFileCollection, historyPath);
    }

    private void createCommandOutputHistory(ICommandInfo commandInfo, Collection<FileParameterValue> outputFileCollection) {
        String commandId = FileUtils.fixDirectoryName((String)commandInfo.getCommandId());
        String projectId = commandInfo.getProjectId();
        String[] historyPath = new String[]{".cmds", commandId, "FILES", "OUTPUT_FILES"};
        if (!this.projectService.existsFile((Object)projectId, historyPath)) {
            this.projectService.createDirectory((Object)projectId, historyPath);
        }
        this.createCommandHistory(commandInfo, outputFileCollection, historyPath);
    }

    private void createCommandHistory(ICommandInfo commandInfo, Collection<FileParameterValue> fileCollection, String[] historyPath) {
        if (fileCollection == null || fileCollection.size() == 0) {
            return;
        }
        String projectId = commandInfo.getProjectId();
        int numFiles = fileCollection.size();
        Iterator<FileParameterValue> fileIterator = fileCollection.iterator();
        for (int i = 0; i < numFiles; ++i) {
            FileParameterValue file = fileIterator.next();
            Object[] filePath = file.getPathAsArray();
            if (Arrays.binarySearch(filePath, ".cmds") >= 0) continue;
            String[] fullPath = new String[historyPath.length + filePath.length];
            System.arraycopy(historyPath, 0, fullPath, 0, historyPath.length);
            System.arraycopy(filePath, 0, fullPath, historyPath.length, filePath.length);
            try {
                String[] dirPath = new String[fullPath.length - 1];
                for (int j = 0; j < fullPath.length - 1; ++j) {
                    dirPath[j] = fullPath[j];
                }
                File fsFile = new File(this.projectService.getAbsolutePath((Object)projectId, (String[])filePath));
                if (fsFile.isDirectory()) {
                    if (!this.projectService.existsFile((Object)projectId, fullPath)) {
                        this.projectService.createDirectory((Object)projectId, fullPath);
                    }
                    ClientProjectFile[] children = this.projectService.getChildren((Object)projectId, (String[])filePath, true);
                    ArrayList<FileParameterValue> childrenList = new ArrayList<FileParameterValue>();
                    for (ClientProjectFile c : children) {
                        String[] path = c.getPath();
                        FileParameterValue fpv = new FileParameterValue(FileUtils.joinPath((char)'/', (String[])path));
                        childrenList.add(fpv);
                    }
                    this.createCommandHistory(commandInfo, childrenList, historyPath);
                    continue;
                }
                if (!this.projectService.existsFile((Object)projectId, dirPath)) {
                    this.projectService.createDirectory((Object)projectId, dirPath);
                }
                if (this.projectService.existsFile((Object)projectId, fullPath)) {
                    this.projectService.removeFile((Object)projectId, fullPath);
                }
                this.projectService.copyFile((Object)projectId, (String[])filePath, dirPath);
                continue;
            }
            catch (Exception e) {
                Server.logSevereMessage((String)("Falha na cria\u00e7\u00e3o do arquivo " + file.getPath()), (Throwable)e);
            }
        }
    }
}

