/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

public class OutputFileParameterParser
extends AbstractFileParameterParser<OutputFileParameter> {
    public static final String OUTPUT_FILE_PARAMETER_ELEMENT = "arquivo_de_saida";
    protected static final String OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE = "forcar_extensao";
    protected static final boolean OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_DEFAULT_VALUE = false;

    @Override
    public OutputFileParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String type, FileParameterMode mode) throws ParseException {
        boolean mustSort;
        boolean sortDefined = parser.hasAttributeValue("ordenar");
        if (sortDefined && (mustSort = parser.extractAttributeValueAsBoolean("ordenar", true))) {
            throw new ParseException("Arquivo de saida n\u00e3o admite atributo: ordenar");
        }
        FileParameterPipeAcceptance usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE, new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter(this));
        boolean mustForceExtension = parser.extractAttributeValueAsBoolean(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE, false);
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        FileURLValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("O atributo {0} \u00e9 inv\u00e1lido quando o par\u00e2metro de sa\u00edda \u00e9 um arquivo.", "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new FileURLValue(".", "DIRECTORY_TYPE");
        }
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, type, mode, usesPipe, mustForceExtension, useFilter);
        return parameter;
    }

    @Override
    protected boolean acceptBothCategory() {
        return false;
    }
}

