/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Desabilitar Parmetro: Desabilita um {@link SimpleParameter
 * parmetro} quando a {@link Condition condio} associada for aceita.
 * 
 * @author lmoreira
 */
public final class DisableParameterTrigger extends Trigger<SimpleParameter<?>> {
  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public DisableParameterTrigger(SimpleParameter<?> parameter,
    Condition condition) {
    super(parameter, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setEnabled(true);
  }
}
