package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Exibe/Oculta Item de Enumerao: Exibe/Oculta um
 * {@link EnumerationItem item de enumerao} do {@link EnumerationParameter
 * parmetro do tipo Enumerao} quando a {@link Condition condio} associada
 * for aceita.
 */
public final class SetVisibleEnumerationItemTrigger extends
  Trigger<EnumerationParameter> {
  /**
   * O item de enumerao.
   */
  private String itemId;

  /**
   * Indica se  para exibir/ocultar o item.
   */
  private boolean isVisible;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param itemId O identificador do item (No aceita {@code null}).
   * @param isVisible Indica se  para exibir/ocultar o item.
   */
  public SetVisibleEnumerationItemTrigger(EnumerationParameter parameter,
    Condition condition, String itemId, boolean isVisible) {
    super(parameter, condition);
    setItemId(itemId);
    this.isVisible = isVisible;
  }

  /**
   * Indica se este gatilho tem que exibir/ocultar o item.
   * 
   * @return {@code true} se ele tem exibir ou {@code false} se ele tem que
   *         ocultar.
   */
  public boolean isVisible() {
    return isVisible;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (!super.equals(obj)) {
      return false;
    }
    SetVisibleEnumerationItemTrigger trigger =
      (SetVisibleEnumerationItemTrigger) obj;
    if (!getItemId().equals(trigger.getItemId())) {
      return false;
    }

    return isVisible() == trigger.isVisible();
  }

  /**
   * Obtm o item de enumerao.
   * 
   * @return .
   */
  public String getItemId() {
    return itemId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setVisibleItem(itemId, isVisible);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setVisibleItem(itemId, !isVisible);
  }

  /**
   * Atribui o identificador do item de enumerao a este gatilho.
   * 
   * @param itemId O item (No aceita {@code null}).
   */
  private void setItemId(String itemId) {
    if (itemId == null) {
      throw new IllegalArgumentException("O parmetro itemId est nulo.");
    }
    this.itemId = itemId;
  }
}
