package csbase.logic.algorithms.parsers;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;

/**
 * <p>
 * Analisador de {@link InputURLListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "url de entrada" mltiplo.
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link InputURLListParameter}.
 * </p>
 * 
 */
public class InputURLListParameterParser extends
  AbstractURLParameterParser<InputURLListParameter> {

  @Override
  protected InputURLListParameter createURLParameter(XmlParser parser, 
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, String[] types,
    String localization, FileParameterMode mode, FileURLValue defaultValue,
    FileParameterPipeAcceptance usesPipe, EnumSet<URLProtocol> allowedProtocols)
    throws ParseException {

    boolean mustSort =
      parser.extractAttributeValueAsBoolean(MUST_SORT_ATTRIBUTE,
        MUST_SORT_DEFAULT_VALUE);

    List<FileURLValue> defaultValues =
      defaultValue == null ? null : Arrays.asList(defaultValue);
    return new InputURLListParameter(name, label, description, defaultValues,
      isOptional, isVisible, commandLinePattern, localization, types, mode,
      mustSort, allowedProtocols);
  }
}
