package csbase.logic.algorithms.parsers;

import java.util.EnumSet;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;

/**
 * Analisador de parmetros URL de entrada.
 *
 * @author Tecgraf
 */
public final class OutputURLParameterParser extends
  AbstractURLParameterParser<OutputURLParameter> {
  
  @Override
  protected OutputURLParameter createURLParameter(XmlParser parser, String name,
      String label, String description, boolean isOptional, boolean isVisible,
      String commandLinePattern, String[] types, String localization,
      FileParameterMode mode, FileURLValue defaultValue,
      FileParameterPipeAcceptance usesPipe,
      EnumSet<URLProtocol> allowedProtocols) throws ParseException {

    if (types != null && types.length > 1) {
        throw new ParseException(
          "URL de sada no admite mltiplos tipos de arquivo");
    }

    return new OutputURLParameter(name, label, description, defaultValue,
      isOptional, isVisible, commandLinePattern, localization, types, mode,
      usesPipe, allowedProtocols);
  }
}
