package csbase.logic.algorithms.serializer;

import java.io.InputStream;
import java.io.OutputStream;

import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerIOException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParseException;

/**
 * Interface de um objeto utilizado para (des)serializar as configuraces de um
 * configurador de algortmos.
 *
 * @author Tecgraf / PUC-Rio
 */
public interface IAlgorithmConfigurationSerializer {

  /**
   * @param input fluxo de dados com a configuraco de um AlgorithmConfigurator
   *        serializada (No aceita {@code null}).
   *
   * @return Um configurador de algortmos com seus parmetros preenchidos.
   *
   * @throws AlgorithmConfigurationSerializerParseException Quando os dados do
   *         fluxo no estiverem formatados corretamente.
   * @throws AlgorithmConfigurationSerializerIOException Quando ocorrer um erro
   *         de IO no fluxo.
   * @throws AlgorithmNotFoundException Quando a verso do algoritmo utilizado
   *         para criar este configurador no existe mais.
   * @throws AlgorithmConfigurationSerializerException Demais erros que possam
   *         ocorrer na implementaco deste mtodo.
   */
  public AlgorithmConfigurator read(InputStream input)
    throws AlgorithmConfigurationSerializerParseException,
    AlgorithmConfigurationSerializerIOException,
    AlgorithmConfigurationSerializerException, 
    AlgorithmNotFoundException;

  /**
   * @param configurator Um configurador de algortmos (No aceita {@code null}).
   * @param output Fluxo de dados para o qual ser serializada a configuraco do
   *        configurador de algortmos (No aceita {@code null}).
   *
   * @throws AlgorithmConfigurationSerializerIOException Quando ocorrer um erro
   *         de IO no fluxo.
   * @throws AlgorithmConfigurationSerializerException Demais erros que possam
   *         ocorrer na implementaco deste mtodo.
   */
  public void write(AlgorithmConfigurator configurator, OutputStream output)
    throws AlgorithmConfigurationSerializerIOException,
    AlgorithmConfigurationSerializerException;
}
