package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;

/**
 * 
 * <p>
 * Fbrica de parmetros do tipo "arquivo de sada": {@link OutputFileParameter}
 * e {@link OutputFileListParameter}. Como esses dois parmetros podem ser
 * criados a partir de uma mesma tag XML, essa fbrica foi criada para
 * direcionar a anlise para o parser apropriado para cada um dos casos.
 * </p>
 * 
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link OutputFileParameterParser#OUTPUT_FILE_PARAMETER_ELEMENT}.
 * </p>
 * 
 */
public class OutputFileParameterFactory extends FileParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private OutputFileListParameterParser outputFileListParameterParser;

  /**
   * Parser do parmetro simples.
   */
  private OutputFileParameterParser outputFileParameterParser;

  /**
   * Construtor.
   */
  public OutputFileParameterFactory() {
    outputFileListParameterParser = new OutputFileListParameterParser();
    outputFileParameterParser = new OutputFileParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputFileListParameterParser createFileListParser() {
    return outputFileListParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputFileParameterParser createSimpleFileParser() {
    return outputFileParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    List<Class<? extends Parameter>> types = new ArrayList<>();
    types.addAll(outputFileParameterParser.getParameterTypes());
    types.addAll(outputFileListParameterParser.getParameterTypes());
    return types;
  }
}
