package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

public final class ProjectFileRecursiveFilter implements ProjectFileFilter {

  private ProjectFileFilter filter;
  
  public ProjectFileRecursiveFilter(ProjectFileFilter filter) {
    if (filter == null) {
      throw new IllegalArgumentException("filter == null");
    }
    this.filter = filter;
  }

  @Override
  public boolean accept(ClientProjectFile file) {
    if (filter.accept(file)) {
      return true;
    }

    if (file.isDirectory()) {
      ClientProjectFile[] children = file.getLocalChildren();
      if (children == null) {
        // A lista ainda no foi carregada pelo servidor.
        return false;
      }
      for (ClientProjectFile child : children) {
        if (accept(child)) {
          return true;
        }
      }
    }

    return false;
  }

}
