/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;

/**
 * Observador de parmetros.
 *
 * @param <V> O tipo do valor armazenado no parmetro.
 *
 * @author lmoreira
 */
public interface ParameterListener<V> {
  /**
   * Indica que houve mudana no estado habilitado/desabilitado de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void capabilityWasChanged(Parameter<V> parameter);

  /**
   * Indica que houve mudana no valor-padro de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void defaultValueWasChanged(
    Parameter<V> parameter);

  /**
   * Indica que houve mudana no valor de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void valueWasChanged(Parameter<V> parameter);

  /**
   * Indica que houve mudana no estado visvel/oculto de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void visibilityWasChanged(Parameter<V> parameter);
}
