package csbase.logic.algorithms.parameters.triggers;

import java.util.Arrays;

import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Trocar Tipo de Arquivo: Modifica o tipo do arquivo aceito por um
 * {@link FileParameter parmetro do tipo Arquivo} quando a {@link Condition
 * condio} for aceita.
 * 
 * @author lmoreira
 */
public final class ChangeFileTypeTrigger extends Trigger<FileParameter> {
  /**
   * O tipo do arquivo.
   */
  private String[] fileTypes;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param fileTypes O tipo do arquivo (Aceita {@code null}).
   */
  public ChangeFileTypeTrigger(FileParameter parameter, Condition condition,
    String[] fileTypes) {
    super(parameter, condition);
    this.fileTypes = fileTypes;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (super.equals(obj)) {
      ChangeFileTypeTrigger trigger = (ChangeFileTypeTrigger) obj;
      if (this.fileTypes == null && trigger.fileTypes == null) {
        return true;
      }
      return (this.fileTypes != null && Arrays
        .equals(this.fileTypes, trigger.fileTypes));
    }
    return false;
  }

  /**
   * Obtm o tipo do arquivo.
   * 
   * @return O tipo do arquivo (Pode ser {@code null}).
   */
  public String[] getFileTypes() {
    return this.fileTypes;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setFileTypes(getFileTypes());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    // @todo Auto-generated method stub
  }
}
