package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;

/**
 * Define uma interface para converso de strings para seus valores
 * correspondentes em uma enumerao E. Permite que diferentes string possam ser
 * mapeadas para um mesmo valor da enumerao.
 * 
 * Essa interface  utilizada pelo {@link XmlParser} para transformar strings
 * lidas diretamente em enumeraes.
 * 
 * @param <E> Enumerao cujos valores sero mapeados
 * 
 */
public interface StringToEnumConverter<E extends Enum<E>> {

  /**
   * Retorna o valor da enumerao que corresponde a uma determinada string.
   * 
   * @param string A string a ser convertida (No aceita {@code null}).
   * @return O valor da enumerao que corresponde  string.
   * @throws ParseException Caso no seja possvel converter a string em um item
   *         de enumerao.
   * 
   */
  public E valueOf(String string) throws ParseException;

}
