package csbase.logic.algorithms.parsers.elements;

import static csbase.logic.algorithms.parsers.elements.ParameterStructure
  .COMMAND_LINE_PATTERN_ELEMENT;
import static csbase.logic.algorithms.parsers.elements.ParameterStructure
  .PARAMETER_ELEMENT_NAME_ATTRIBUTE;

import java.util.List;
import java.util.Map;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;

/**
 * Parmetro lido pelo parser.
 */
public class ParsedParameter extends ParsedElement {

  /**
   * Nome do parmetro.
   */
  private final String name;

  /**
   * Padro da linha de comando do parmetro.
   */
  private final String commandLinePattern;

  /**
   * Construtor.
   *
   * @param attributeValues mapa de valores dos atributos.
   * @param children lista de elementos-filhos.
   * @param defaultCommandLinePattern valor padro da linha de comando.
   * @throws ParseException em caso de erro.
   */
  public ParsedParameter(Map<IElementAttribute<?>, Object> attributeValues,
    Map<IElementStructure<?>, List<ParsedElement>> children,
    String defaultCommandLinePattern) throws ParseException {
    super(attributeValues, children);
    this.name = getAttributeValue(PARAMETER_ELEMENT_NAME_ATTRIBUTE);
    List<ParsedElement> commandLineElement =
      getChildren(COMMAND_LINE_PATTERN_ELEMENT);
    if (commandLineElement != null && !commandLineElement.isEmpty()) {
      this.commandLinePattern = commandLineElement.get(0).getContentValue();
    }
    else {
      this.commandLinePattern = defaultCommandLinePattern;
    }
  }

  /**
   * Obtm  o nome do parmetro.
   *
   * @return o nome.
   */
  public String getName() {
    return name;
  }

  /**
   * Obtm o padro de linha de comando do parmetro.
   *
   * @return o padro de linha de comando.
   */
  public String getCommandLinePattern() {
    return commandLinePattern;
  }

}
