package csbase.logic;

/**
 * Permisso genrica para autorizar acesso a servios e sistemas externos, que
 * necessitem de senha. O usurio e senha do servio externo ficam armazenados
 * na permisso.
 * 
 * @author Tecgraf
 */
public abstract class ExternalAccessPermission extends UserPasswordPermission {

  /**
   * Construtor.
   */
  public ExternalAccessPermission() {
    super();
  }

  /**
   * Construtor. Define o nome, o usurio e a senha da permisso sendo criada.
   * 
   * @param name Nome da permisso.
   * @param description Descrio da permisso.
   * @param user Usurio associado.
   * @param password Senha associado.
   */
  public ExternalAccessPermission(String name, String description, String user,
    String password) {
    super(name, description, user, password);
  }

  /**
   * @return Identifica o servio externo que est sendo acessado.
   */
  public abstract String getExternalIdentification();
}