/**
 * $Id: NewProjectFileEvent.java 146059 2013-10-22 18:32:34Z fpina $
 */

package csbase.logic;

/**
 * Representa o evento de incluso de arquivo na rvore do projeto. Objetos
 * dessa classe so criados pelo servidor.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class NewProjectFileEvent extends ProjectEvent {

  /** Caminho do diretrio aonde o arquivo foi criados. */
  private String[] path;

  /** Arquivo criado na rvore do projeto. */
  private ClientProjectFile file;

  /**
   * Obtm um {@link ClientProjectFile} representando o caminho de cada arquivo
   * criado.<br>
   * Obs.: este caminho  relativo ao diretrio aonde os projetos so
   * armazenados. Em outras palavras, o ancestral mais antigo ser o diretrio
   * do projeto aonde o arquivo foi criado.
   * 
   * @return um {@link ClientProjectFile} representando o caminho de cada
   *         arquivo criado.
   */
  public ClientProjectFile getFile() {
    return file;
  }

  /**
   * Obtm o caminho do diretrio no qual foi criado um arquivo como resultado
   * do evento ocorrido.
   * 
   * @return O caminho do diretrio onde o arquivo foi criado.
   */
  public String[] getPath() {
    return path;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de incluso
   * de um arquivo na rvore de um projeto.
   * 
   * @param projectId o identificador do projeto sendo atualizado.
   * @param path o caminho do diretrio aonde o arquivo foi criado.<br>
   *        Obs.: este caminho deve ser relativo ao diretrio aonde os projetos
   *        so armazenados. Em outras palavras, o ancestral mais antigo dever
   *        ser o diretrio do projeto aonde o arquivo foi criado.
   * @param file um {@link ClientProjectFile} representando o arquivo criado. <br>
   *        O mtodo {@link ClientProjectFile#getParent()} ir retornar null,
   *        pois por motivos de consistncia, este valor no foi atribuido no
   *        servidor.
   */
  NewProjectFileEvent(Object projectId, String[] path, ClientProjectFile file) {
    event = NEW_FILE;
    this.projectId = projectId;
    this.file = file;
    this.path = path;
  }
}
