/*
 * $Id: OpenProjectNotification.java 116055 2011-03-04 18:15:45Z cassino $
 */
package csbase.logic;

/**
 * Notificao de abertura de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class OpenProjectNotification extends Notification {

  /**
   * Nome do projeto.
   */
  private final String projectName;

  /**
   * Obtm o nome do projeto.
   * 
   * @return o nome
   */
  public String getProjectName() {
    return this.projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "Notificao de abertura do projeto: " + projectName;
  }

  /**
   * Construtor
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param projectName o nome do projeto.
   */
  public OpenProjectNotification(String sender, String projectName) {
    super(sender);
    this.projectName = projectName;
  }
}
