/*
 * SGAFile.java
 * 
 * $Author: lmoreira $ $Revision: 169707 $ - $Date: 2006-12-07 15:53:32 -0200
 * (Thu, 07 Dec 2006) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Classe que define um aruivo a ser criado por um SGA decorrente da execuo de
 * um algoritmo.
 */
public class SGAFile implements Serializable {
  /** Define o tipo do arquivo baseado na classe <code>ProjectFileType</code>. */
  private String fileType;
  /**
   * Nome do arquivo definido como array de strings de modo a abstrair o
   * separador de paths (definido pelo SGA).
   */
  private String[] fileName;

  /**
   * Consulta ao tipo do arquivo.
   * 
   * @return o tipo definido em <code>FileType</code>.
   */
  public String getFileType() {
    return fileType;
  }

  /**
   * Consulta ao noem do arquivo como array.
   * 
   * @return o array.
   */
  public String[] getFileName() {
    return fileName;
  }

  /**
   * Consulta ao nome do arquivo como string dependente do separator envolvido.
   * 
   * @param sep o separador
   * 
   * @return a string com o path completo.
   */
  public String getFileNameForSeparator(char sep) {
    String[] path = getFileName();
    if ((path == null) || (path.length <= 0)) {
      return "";
    }
    StringBuilder fileName = new StringBuilder();
    for (int i = 0; i < (path.length - 1); i++) {
      fileName.append(path[i]);
      fileName.append(sep);
    }
    fileName.append(path[path.length - 1]);
    return fileName.toString();
  }

  /**
   * Mtodo de impresso do arquivo
   * 
   * @return uma string do arquivo com separador padro
   */
  @Override
  public String toString() {
    return getFileNameForSeparator('/');
  }

  /**
   * Consulta ao nome do arquivo como string dependente do SGA envolvido
   * (separador).
   * 
   * @param sga informao sobre o SGA envolvido.
   * 
   * @return a string com o path completo.
   */
  public String getFileNameForSGA(SGAInfo sga) {
    if (sga == null) {
      return "";
    }
    char sep = sga.getFileSeparator();
    return getFileNameForSeparator(sep);
  }

  /**
   * Construtor secundrio para arquivos criados no diretrio-raiz projeto onde
   * o array de strings pode ser definido por uma nica string.
   * 
   * @param type tipo definido em <code>ProjectFileType</code>.
   * @param name nome do arquivo (sem path no diretrio raiz).
   */
  public SGAFile(String type, String name) {
    fileType = type;
    fileName = new String[1];
    fileName[0] = name;
  }

  /**
   * Construtor padro.
   * 
   * @param type tipo definido em <code>ProjectFileType</code>.
   * @param name vetor de strings que definem o nome do arquivo.
   */
  public SGAFile(String type, String[] name) {
    this.fileType = type;
    this.fileName = name.clone();
  }
}
