package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Modificar Valor-Padro: Modifica o valor-padro de um
 * {@link SimpleParameter parmetro} quando a {@link Condition condio}
 * associada for verdadeira.
 * 
 * @author lmoreira
 * @param <V> tipo do valor do parmetro.
 */
public final class ChangeDefaultValueTrigger<V> extends
  Trigger<SimpleParameter<V>> {
  /**
   * O valor-padro.
   */
  private V defaultValue;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   */
  public ChangeDefaultValueTrigger(SimpleParameter<V> parameter,
    Condition condition, V defaultValue) {
    super(parameter, condition);
    this.defaultValue = defaultValue;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (super.equals(obj)) {
      ChangeDefaultValueTrigger<?> trigger = (ChangeDefaultValueTrigger<?>) obj;
      if (this.defaultValue == null && trigger.defaultValue == null) {
        return true;
      }
      return (this.defaultValue != null && this.defaultValue
        .equals(trigger.defaultValue));
    }
    return false;
  }

  /**
   * Obtm o valor-padro.
   * 
   * @return O valor-padro (Pode ser {@code null}).
   */
  public Object getDefaultValue() {
    return this.defaultValue;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setDefaultValue(this.defaultValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    //@todo
  }
}
