package csbase.logic.algorithms.parsers.elements;

import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;

/**
 * Estrutura de um parmetro simples.
 */
public class SimpleParameterStructure <T extends SimpleParameter<?>> extends
  ParameterStructure<T> {

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE} dos
   * elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * Indica o valor-padro do parmetro.  opcional. O seu tipo dependente do
   * tipo do parmetro:<br>
   * <table summary="valor padro">
   * <tr>
   * <td>{@link BooleanParameter}</td>
   * <td>booleano</td>
   * </tr>
   * <tr>
   * <td>{@link DoubleParameter}</td>
   * <td>real</td>
   * </tr>
   * <tr>
   * <td>{@link EnumerationParameter}</td>
   * <td>string (o identificador de {@link EnumerationItem item de enumerao})
   * </td>
   * </tr>
   * <tr>
   * <td>{@link FormulaParameter}</td>
   * <td>string</td>
   * </tr>
   * <tr>
   * <td>{@link IntegerParameter}</td>
   * <td>inteiro</td>
   * </tr>
   * <tr>
   * <td>{@link TextParameter}</td>
   * <td>texto</td>
   * </tr>
   * </table>
   */
  public static final String PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE = "padrao";

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica se o parmetro deve ficar visvel.  opcional, o seu valor-padro 
   * {@link #PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE_DEFAULT_VALUE} e o seu tipo 
   * booleano.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE = "oculto";

  /**
   * <p>
   * O valor-padro para o atributo {@link #PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE}.
   * </p>
   * <p>
   * O seu valor  {@value #PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE_DEFAULT_VALUE}.
   * </p>
   */
  static final boolean PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE_DEFAULT_VALUE = false;

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica a descrio do parmetro.  obrigatria e o seu tipo  string.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE = "dica";

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_LABEL_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica o rtulo do parmetro.  obrigatria e o seu tipo  string.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_LABEL_ATTRIBUTE = "rotulo";

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica se o valor do parmetro  opcional.  opcional, o seu valor-padro 
   * {@link #PARAMETER_ELEMENT_OPTIONAL_DEFAULT_VALUE} e o seu tipo  booleano.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE = "opcional";

  /**
   * <p>
   * O valor-padro para o atributo
   * {@link #PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE}.
   * </p>
   * <p>
   * O seu valor  {@value #PARAMETER_ELEMENT_OPTIONAL_DEFAULT_VALUE}.
   * </p>
   */
  static final boolean PARAMETER_ELEMENT_OPTIONAL_DEFAULT_VALUE = false;

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE} dos
   * elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica se o parmetro deve ser ignorado (no deve fazer parte da linha de
   * comando gerada), caso esteja desabilitado no configurador.  opcional, o
   * seu valor-padro 
   * {@link #PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE} e o seu tipo 
   * booleano.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE =
    "ignorar_se_desabilitado";

  /**
   * <p>
   * O valor-padro para o atributo
   * {@link #PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE}.
   * </p>
   * <p>
   * O seu valor  {@value #PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE}.
   * </p>
   */
  static final boolean PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE =
    false;

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE} dos
   * elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica se o parmetro deve ser ignorado (no deve fazer parte da linha de
   * comando gerada), caso esteja invisvel(oculto) no configurador.  opcional,
   * o seu valor-padro 
   * {@link #PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_DEFAULT_VALUE} e o seu tipo 
   * booleano.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE =
    "ignorar_se_oculto";

  /**
   * <p>
   * O valor-padro para o atributo
   * {@link #PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE}.
   * </p>
   * <p>
   * O seu valor  {@value #PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_DEFAULT_VALUE}
   * .
   * </p>
   */
  static final boolean PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_DEFAULT_VALUE =
    false;

  /**
   * Construtor.
   *
   * @param tag nome do parmetro.
   * @param parameterClass classe do parmetro.
   */
  public SimpleParameterStructure(String tag, Class<T> parameterClass) {
    super(tag, parameterClass);
    addAttribute(new StringAttribute(PARAMETER_ELEMENT_LABEL_ATTRIBUTE));
    addAttribute(new StringAttribute(PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE));
    addAttribute(
      new BooleanAttribute(PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE,
        PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_DEFAULT_VALUE));
    addAttribute(
      new BooleanAttribute(PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE,
        PARAMETER_ELEMENT_IGNORE_IF_DISABLED_DEFAULT_VALUE));
    addAttribute(new BooleanAttribute(PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE,
      PARAMETER_ELEMENT_OPTIONAL_DEFAULT_VALUE));
    addAttribute(new BooleanAttribute(PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE,
      PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE_DEFAULT_VALUE));
  }

}
