package csbase.logic.algorithms.parsers.elements.attributes;

import java.io.Serializable;

import csbase.exception.ParseException;

/**
 * Define uma interface para converso de strings para seus valores
 * correspondentes.
 *
 * @param <V> Tipo do valor
 */
public interface StringToValueConverter <V> extends Serializable {

  /**
   * Retorna o valor do atributo que corresponde a uma determinada string.
   *
   * @param string A string a ser convertida (No aceita {@code null}).
   * @return O valor do atributo que corresponde  string.
   *
   * @throws ParseException Caso no seja possvel converter a string em um
   * valor vlido.
   */
  public V valueOf(String string) throws ParseException;

}
