package csbase.logic.algorithms.serializer.exception;

/**
 * Exceco genrica lancada durante a serializaco ou deserializaco das
 * configuraces de um algortimo.
 * 
 * @author Tegraf / PUC-Rio
 */
public class AlgorithmConfigurationSerializerException extends Exception {
  public AlgorithmConfigurationSerializerException(Throwable cause) {
    super(createExceptionMessage(cause), cause);
  }

  private static String createExceptionMessage(Throwable cause) {
    if (null == cause.getMessage()) {
      return "Ocorreu um erro do tipo " + cause.getClass().getName()
        + " ao tentar (des)serializar um configurador";
    }
    else {
      return cause.getMessage();
    }
  }
}
