/*
 * $Id$
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.Set;

import scs.core.ComponentId;
import csbase.logic.BusInfo;

/**
 * Representa o servio que trata da conexo do CSBase com o OpenBus.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface OpenBusServiceInterface extends ServiceInterface {
  /**
   * O nome do servio.
   */
  String SERVICE_NAME = "OpenBusService";

  /**
   * Obtm informaes sobre a localizao do OpenBus.
   * 
   * @return A localizao do OpenBus.
   * 
   * @throws RemoteException Usada pelo mecanismo de RMI.
   */
  BusInfo getBusInfo() throws RemoteException;

  /**
   * Obtm um conjunto com os componentes registrados. S pode ser executado
   * pelo admin.
   * 
   * @return conjunto com os componentes registrados
   * @throws RemoteException Usada pelo mecanismo de RMI.
   */
  Set<ComponentId> getRegisteredComponents() throws RemoteException;

  /**
   * Obtm um conjunto com os componentes com falha no registro. S pode ser
   * executado pelo admin.
   * 
   * @return conjunto com os componentes com falha no registro
   * @throws RemoteException Usada pelo mecanismo de RMI.
   */
  Set<ComponentId> getFailedComponents() throws RemoteException;
}
