package csbase.logic.algorithms.parsers.elements;

import java.io.Serializable;
import java.util.List;

import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;

/**
 * Descreve um elemento a ser analisado pelo parser.
 */
public interface IElementStructure <T> extends Serializable {

  /**
   * Obtm o nome do elemento.
   *
   * @return o nome.
   */
  public String getName();

  /**
   * Obtm a lista de atributos do elemento.
   *
   * @return a lista de atributos.
   */
  public List<IElementAttribute<?>> getAttributes();

  /**
   * Obtm a lista de filhos do elemento.
   *
   * @return a lista de elementos-filhos.
   */
  public List<IElementStructure<?>> getChildElements();

  /**
   * Obtm a classe do elemento.
   *
   * @return a classe.
   */
  public Class<T> getElementClass();

}
