package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;

/**
 * Atributo de tipo enumerao de {@link FileParameterPipeAcceptance}
 */
public class FileElementPipeAcceptanceAttribute extends
  EnumerationAttribute<FileParameterPipeAcceptance> {

  /**
   * Construtor para atributos obrigatrios.
   *
   * @param name nome do atributo.
   */
  public FileElementPipeAcceptanceAttribute(String name) {
    super(name, FileParameterPipeAcceptance.class,
      new FileParameterPipeAcceptanceConverter());
  }

  /**
   * Construtor para atributos opcionais.
   *
   * @param name nome do atributo.
   * @param defaultValue valor padro do atributo.
   */
  public FileElementPipeAcceptanceAttribute(String name,
    FileParameterPipeAcceptance defaultValue) {
    super(name, FileParameterPipeAcceptance.class, defaultValue, null,
      new FileParameterPipeAcceptanceConverter());
  }

  /**
   * Converte strings para valores da enumerao FileParameterPipeAcceptance.
   */
  public static class FileParameterPipeAcceptanceConverter implements
    StringToValueConverter<FileParameterPipeAcceptance> {

    /**
     * Retorna as strings que correspondem a cada um dos possveis valores da
     * enumerao {@link FileParameterPipeAcceptance}.
     *
     * @param value O valor da enumerao.
     * @return Um array com todas as strings que podem representar o valor.
     */
    public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
      switch (value) {
        case TRUE:
          return BooleanAttribute.TRUE_VALUES;
        case FALSE:
          return BooleanAttribute.FALSE_VALUES;
        case ALWAYS:
          return new String[] { "sempre", "always" };
        default:
          throw new BugException();
      }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileParameterPipeAcceptance valueOf(
      String string) throws ParseException {
      if (string != null) {
        String upperCaseString = string.toUpperCase();
        for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance
          .values()) {
          String[] possibleMatches = getPossibleMatches(mode);
          for (String possibleMatch : possibleMatches) {
            if (possibleMatch.toUpperCase().equals(upperCaseString)) {
              return mode;
            }
          }
        }
      }
      throw new ParseException(
        "A string " + string + " no pde ser mapeada para um item de " +
          "enumerao do tipo " + FileParameterPipeAcceptance.class
          .getName());
    }
  }


}
