package csbase.logic;

/**
 * The Class CommandViewPermission.
 */
public class CommandViewPermission extends AttributesPermission {

  /**
   * Construtor
   */
  public CommandViewPermission() {
    super();
  }

  /**
   * Construtor.
   * 
   * @param name nome da permisso
   * @param description descrio
   * @param attributes atributos da permisso
   */
  public CommandViewPermission(String name, String description,
    String[] attributes) {
    super(name, description, attributes);
  }

  /**
   * Verifica se o usurio tem acesso a um determinado tipo de viso do comando.
   * 
   * @param user usurio que solicita o tipo de viso do comando.
   * @param viewType identificador do tipo de viso que se deseja verificar a
   *        permisso.
   * 
   * @return retorna true se o usurio tem acesso ao tipo de viso de comando
   *         especificado ou false, caso contrrio.
   * @throws Exception erro ocorrido durante a busca pela permisso (ex: de rmi)
   * 
   */
  public static boolean checkCommandViewPermission(User user, String viewType)
    throws Exception {
    boolean hasPermission = false;

    String[] attributes = new String[] { viewType };
    CommandViewPermission permission =
      (CommandViewPermission) user.getMatchAttributesPermission(
        CommandViewPermission.class, attributes);

    if (permission != null) {
      hasPermission = true;
    }
    return hasPermission;
  }

}
