/*
 * NotificationProjectData.java
 * 
 * $Id: ProjectNotification.java 116055 2011-03-04 18:15:45Z cassino $
 */
package csbase.logic;

/**
 * Classe que modela uma notificao de projeto.
 */
public class ProjectNotification extends Notification {

  /** Guarda o objeto que descreve as informaes administrativas do projeto. */
  private ProjectAdminInfo info;

  /**
   * Consulta as informaes administrativas do projeto.
   * 
   * @return o objeto que contem dados de administrao do projeto
   */
  public ProjectAdminInfo getProjectAdminInfo() {
    return info;
  }

  /**
   * Definio da volatilidade da notificao.
   * 
   * @return flag indicativo.
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * String para auditagem.
   * 
   * @return uma string
   */
  @Override
  public String toString() {
    return "PROJECT ADMIN (" + info.getProjectName() + ")";
  }

  /**
   * Constri o evento de notificao de administrao de projeto
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param info A informao de administrao.
   */
  public ProjectNotification(String sender, ProjectAdminInfo info) {
    super(sender);
    this.info = info;
  }
}
