package csbase.logic.algorithms;

import java.util.List;

/**
 * Interface para objetos que possuam um histrico associado. 
 *
 * @author Leonardo Barros
 */
public interface HistoryProvider {

  /**
   * Obtm o histrico associado ao objeto.
   * 
   * @return histrico associado ao objeto.
   */
  List getHistory();

  /**
   * Obtm o nome do objeto que est provendo o histrico.
   * 
   * @return nome do objeto que est provendo o histrico.
   */
  String getName();
}
