package csbase.logic.algorithms.parsers;

import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;

/**
 * <p>
 * Analisador de {@link EnumerationListParameter} .
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "enumerao mltipla". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link EnumerationListParameter}.
 * </p>
 */
public class EnumerationListParameterParser extends
  AbstractEnumerationParameterParser<EnumerationListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  protected EnumerationListParameter createEnumerationParameter(
    XmlParser parser, String name, String label, String description,
    boolean isOptional, boolean isVisible, String commandLinePattern,
    boolean mustSort, List<EnumerationItem> items,
    String defaultItemId) throws ParseException {
    EnumerationListParameter parameter =
      new EnumerationListParameter(name, label, description, null, isOptional,
        isVisible, commandLinePattern, mustSort);
    parameter.setItems(items);
    return parameter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<EnumerationListParameter> getParameterStructure() {
    return getEnumerationStructure(ENUMERATION_PARAMETER_ELEMENT,
      EnumerationListParameter.class);
  }
}
