package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;

/**
 * Representa uma fbrica que sabe construir mais de um tipo de parametro
 * baseado em um atributo booleano.
 */
public interface MultipleParameterFactory extends ParameterFactory {

  /**
   * Obtm o atributo booleano cujo valor diferencia o tipo de parmetro.
   * 
   * @return o atributo booleano que diferencia o tipo de parmetro.
   */
  public BooleanAttribute getAttribute();

  /**
   * Obtm o tipo de parmetro de acordo com o valor booleano recebido.
   * 
   * @param value valor booleano que determina qual tipo de parmetro deve ser
   *        retornado.
   * @return a lista de classes de parmetros criados por esta fbrica, de
   *         acordo com o valor booleano recebido.
   */
  public ParameterStructure<?> getParameterStructure(boolean value);

}
