/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.FileElementPipeAcceptanceAttribute;
import tecgraf.javautils.core.lng.LNG;

public class InputFileParameterParser
extends AbstractFileParameterParser<InputFileParameter> {
    public static final String INPUT_FILE_PARAMETER_ELEMENT = "arquivo_de_entrada";

    @Override
    public InputFileParameter createFileParameter(ParsedSimpleParameter definition, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe = (FileParameterPipeAcceptance)((Object)definition.getAttributeValue("permitir_pipe"));
        if (usesPipe != FileParameterPipeAcceptance.FALSE && types.length > 1) {
            throw new ParseException("O valor {0} do atributo {1} \u00e9 inv\u00e1lido quando se tem mais de um tipo de arquivo definido no par\u00e2metro.", new Object[]{usesPipe, "permitir_pipe"});
        }
        boolean useRootDirectoryAsDefault = (Boolean)definition.getAttributeValue("usar_diretorio_raiz_como_padrao");
        FileURLValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InputFileInvalidAttribute"), "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new FileURLValue(".", "DIRECTORY_TYPE");
        }
        boolean useFilter = (Boolean)definition.getAttributeValue("usar_filtro");
        InputFileParameter parameter = new InputFileParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), types, mode, usesPipe, useFilter);
        return parameter;
    }

    @Override
    public ParameterStructure<InputFileParameter> getParameterStructure() {
        ParameterStructure<InputFileParameter> fileStructure = this.getFileStructure(INPUT_FILE_PARAMETER_ELEMENT, InputFileParameter.class);
        fileStructure.addAttribute(new FileElementPipeAcceptanceAttribute("permitir_pipe", FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE));
        fileStructure.addAttribute(new BooleanAttribute("usar_diretorio_raiz_como_padrao", false));
        fileStructure.addAttribute(new BooleanAttribute("usar_filtro", false));
        return fileStructure;
    }

    @Override
    protected boolean acceptBothCategory() {
        return true;
    }
}

