/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.FileElementPipeAcceptanceAttribute;
import tecgraf.javautils.core.lng.LNG;

public class OutputFileParameterParser
extends AbstractFileParameterParser<OutputFileParameter> {
    public static final String OUTPUT_FILE_PARAMETER_ELEMENT = "arquivo_de_saida";
    protected static final String OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE = "forcar_extensao";
    protected static final boolean OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_DEFAULT_VALUE = false;
    protected static final String OUTPUT_FILE_PARAMETER_ELEMENT_ALLOW_MULTIPLE_OUTPUT_ATTRIBUTE = "permitir_bifurcacao";
    protected static final boolean OUTPUT_FILE_PARAMETER_ELEMENT_ALLOW_MULTIPLE_OUTPUT_DEFAULT_VALUE = false;

    @Override
    public OutputFileParameter createFileParameter(ParsedSimpleParameter definition, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe = (FileParameterPipeAcceptance)((Object)definition.getAttributeValue("permitir_pipe"));
        boolean mustForceExtension = (Boolean)definition.getAttributeValue(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE);
        boolean useRootDirectoryAsDefault = (Boolean)definition.getAttributeValue("usar_diretorio_raiz_como_padrao");
        FileURLValue defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.OutputFileInvalidAttribute"), "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new FileURLValue(".", "DIRECTORY_TYPE");
        }
        boolean useFilter = (Boolean)definition.getAttributeValue("usar_filtro");
        boolean allowMultipleOutput = (Boolean)definition.getAttributeValue(OUTPUT_FILE_PARAMETER_ELEMENT_ALLOW_MULTIPLE_OUTPUT_ATTRIBUTE);
        if (types != null && types.length > 1) {
            throw new ParseException("Arquivo de sa\u00edda n\u00e3o admite m\u00faltiplos tipos de arquivo");
        }
        OutputFileParameter parameter = new OutputFileParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), types, mode, usesPipe, mustForceExtension, useFilter, allowMultipleOutput);
        return parameter;
    }

    @Override
    public ParameterStructure<OutputFileParameter> getParameterStructure() {
        ParameterStructure<OutputFileParameter> fileStructure = this.getFileStructure(OUTPUT_FILE_PARAMETER_ELEMENT, OutputFileParameter.class);
        fileStructure.addAttribute(new FileElementPipeAcceptanceAttribute("permitir_pipe", FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE));
        fileStructure.addAttribute(new BooleanAttribute(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE, false));
        fileStructure.addAttribute(new BooleanAttribute("usar_diretorio_raiz_como_padrao", false));
        fileStructure.addAttribute(new BooleanAttribute("usar_filtro", false));
        fileStructure.addAttribute(new BooleanAttribute(OUTPUT_FILE_PARAMETER_ELEMENT_ALLOW_MULTIPLE_OUTPUT_ATTRIBUTE, false));
        return fileStructure;
    }

    @Override
    protected boolean acceptBothCategory() {
        return false;
    }
}

