/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.eventlogservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LogsInfo
implements Serializable {
    private List<String[]> loginTable = new ArrayList<String[]>();
    private List<String[]> applicationsTable = new ArrayList<String[]>();
    private List<String[]> executionsTable = new ArrayList<String[]>();
    private final Date startDate;
    private final Date endDate;

    public LogsInfo() {
        this(null, null);
    }

    public LogsInfo(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public List<String[]> getLoginTable() {
        return this.loginTable;
    }

    public List<String[]> getApplicationsTable() {
        return this.applicationsTable;
    }

    public List<String[]> getExecutionsTable() {
        return this.executionsTable;
    }

    public void addLineLogin(String strDate, String user) {
        this.loginTable.add(new String[]{strDate, user});
    }

    public void addLineApplication(String strDate, String appId, String appDesc) {
        this.applicationsTable.add(new String[]{strDate, appId, appDesc});
    }

    public void addLineExecution(String strDate, String algorithm, String user) {
        this.executionsTable.add(new String[]{strDate, algorithm, user});
    }

    public Set<String> getApplications() {
        TreeSet<String> applications = new TreeSet<String>();
        for (String[] line : this.applicationsTable) {
            String app = line[2];
            applications.add(app);
        }
        return applications;
    }

    public Set<String> getAlgorithms() {
        TreeSet<String> algorithms = new TreeSet<String>();
        for (String[] line : this.executionsTable) {
            String algorithm = line[1];
            algorithms.add(algorithm);
        }
        return algorithms;
    }

    public Map<String, Integer> getExecutionsByUser(List<String> filterAlgorithms) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String[] line : this.executionsTable) {
            String algorithm = line[1];
            if (!filterAlgorithms.contains(algorithm)) continue;
            String user = line[2];
            Integer value = (Integer)map.get(user);
            if (value == null) {
                value = 0;
            }
            map.put(user, value + 1);
        }
        return map;
    }

    public Map<String, Integer> getExecutionsByAlgorithm(List<String> filterAlgorithms) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String[] line : this.executionsTable) {
            String algorithm = line[1];
            if (!filterAlgorithms.contains(algorithm)) continue;
            Integer value = (Integer)map.get(algorithm);
            if (value == null) {
                value = 0;
            }
            map.put(algorithm, value + 1);
        }
        return map;
    }

    public Map<String, Integer> getLoginsByUser() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String[] line : this.loginTable) {
            String user = line[1];
            Integer currentValue = (Integer)map.get(user);
            if (currentValue == null) {
                currentValue = 0;
            }
            map.put(user, currentValue + 1);
        }
        return map;
    }
}

