package csbase.logic;

/**
 * Classe que representa os dados padro sobre a execuo de um comando em um
 * SGA. Essa classe deve ser estendida pela notificaes de comando que contm
 * esses dados bsicos.
 * 
 * @author Tecgraf
 */
public abstract class DefaultCommandFinishedNotification extends
  CommandNotification {

  /**
   * Construtor
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param startTime Hora de incio
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public DefaultCommandFinishedNotification(String sender,
    Object commandId, String cmdDesc, String tip, long startTime,
    String execHost, Object projectId, CommandFinalizationInfo finalizationInfo) {
    super(sender, commandId, cmdDesc, tip, startTime, execHost, projectId,
      finalizationInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String msg =
      "CMD/" + getStatusString() + "(" + cmdDesc + ") (" + getTip() + ")"
        + " - " + commandId + " : ";
    if (finalizationInfo.getExitCode() == null) {
      msg = msg + "cdigo de sada <no informado>, ";
    }
    else {
      msg = msg + "cdigo de sada " + finalizationInfo.getExitCode() + ", ";
    }
    if (startTime >= 0) {
      msg = msg + "hora de incio <no informado>.";
    }
    else {
      msg = msg + "hora de incio " + startTime + ".";
    }
    if ((execHost != null) && (!execHost.equals(""))) {
      msg = msg + "executado por <no informado>.";
    }
    else {
      msg = msg + "executado por " + execHost + ".";
    }
    return msg;
  }
}
