/*
 * Getter.java
 *
 * $Author: cviana $ $Revision: 179359 $ - $Date: 2004-12-30 16:27:57 -0200 (Qui,
 * 30 dez 2004) $
 */
package csbase.logic;

/**
 * A interface <code>Getter</code> define o acesso a um campo de um objeto.
 * 
 * <p>
 * Por exemplo, se um <code>UserOutline</code> quer disponibilizar o acesso aos
 * seus campos de <code>login</code> e <code>UserGroup</code>, a classe define
 * dois mtodos estticos que retornam, cada um deles, um objeto
 * <code>Getter</code> cuja implementao do mtodo <code>get</code> retorna o
 * campo correspondente.
 * </p>
 *
 * @author Maria Julia Lima
 */
public interface Getter {
  /**
   * Retorna o acesso a um campo de um objeto.
   *
   * @param o o objeto que possui o campo a ser acessado.
   *
   * @return acesso a um campo de um objeto.
   */
  Object get(Object o);
}
