/*
 * ProjectSynchronizationData.java
 * $Author: cviana $
 * $Revision: 179359 $ - $Date: 2017-03-13 16:58:16 -0300 (Mon, 13 Mar 2017) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Modela os dados para sincronizao entre dois projetos. Qualquer um deles
 * pode ser local ou remoto. Essa classe existe pelo simples fato de que as
 * informaes dos dois projetos devem ser enviadas para o servidor e depois
 * retornar com alteraes. Como a chamada  remota,  preciso retornar o
 * objeto via serializao. Ou seja, um objeto desta classe deve ser visto
 * como um mero agregador de dois ProjectSynchronizationUnits.
 */
public class ProjectSynchronizationData implements Serializable {
  /**
   * Dados so projeto A
   */
  private ProjectSynchronizationUnit unitA;
  /**
   * Dados do projeto B.
   */
  private ProjectSynchronizationUnit unitB;

  /**
   * Constri um objeto de dados de sincronizao entre projetos contendo as
   * informaes de cada um dos projetos A e B.
   *
   * @param unitA dados do projeto A.
   * @param unitB dados do projeto B.
   */
  public ProjectSynchronizationData(
    ProjectSynchronizationUnit unitA, ProjectSynchronizationUnit unitB) {
    this.unitA = unitA;
    this.unitB = unitB;
  }

  /**
   * Retorna os dados do projeto A.
   * @return dados do projeto A.
   */
  public ProjectSynchronizationUnit getUnitA() {
    return unitA;
  }

  /**
   * Retorna os dados do projeto B.
   * @return dados do projeto B.
   */
  public ProjectSynchronizationUnit getUnitB() {
    return unitB;
  }
}
