package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;

/**
 * Classe para atributos comuns aos parmetros com valores do tipo texto como
 * {@link TextParameter} e {@link TextListParameter}.
 */
public interface TextSctructureAttributes {

  /**
   * O atributo {@value #TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE} dos
   * elementos:
   * <ul>
   * <li>{@link TextColumn} de um {@link TableParameter}</li>
   * <li>{@link TextParameter}</li>
   * <li>{@link TextListParameter}</li>
   * </ul>
   * <p>
   * Informa a quantidade mxima de caracteres que  considerada vlida para os
   * valores da {@link TextColumn coluna do tipo texto} e dos parmetros:
   * {@link TextParameter parmetro do tipo texto} e {@link TextListParameter
   * parmetro do tipo lista de texto}.  opcional,  do tipo inteiro e o seu
   * valor mnimo  {@link #TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE}.
   * </p>
   */
  public static final String TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE =
    "maximo_de_caracteres";

  /**
   * O valor mnimo para o atributo
   * {@link #TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link TextColumn} de um {@link TableParameter}</li>
   * <li>{@link TextParameter}</li>
   * <li>{@link TextListParameter}</li>
   * </ul>
   * <p>
   * O seu valor  {@value #TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE}.
   * </p>
   */
  public static final int TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE = 1;


}
