/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.parameters.FileURLValue;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public final class FlowNode
implements Serializable,
Cloneable {
    private transient AlgorithmConfigurator algorithmConfigurator;
    private String algorithmName;
    private AlgorithmVersionId algorithmVersionId;
    private int height;
    private int id;
    private Set<NodeParameter> parameters;
    private int width;
    private int x;
    private int y;
    private FileURLValue standardOutputFile;
    private FileURLValue exitCodeLogFile;
    private FileURLValue warningsFile;
    private boolean hasExitCode;
    private boolean bypassed;

    public FlowNode(int id, AlgorithmConfigurator algorithmConfigurator, Set<NodeParameter> parameters, int x, int y, int width, int height) {
        this(id, algorithmConfigurator, parameters, x, y, width, height, false);
    }

    public FlowNode(int id, String algorithmName, AlgorithmVersionId algorithmVersionId, Set<NodeParameter> parameters, int x, int y, int width, int height) {
        this(id, algorithmName, algorithmVersionId, parameters, x, y, width, height, false, false);
    }

    public FlowNode(int id, AlgorithmConfigurator algorithmConfigurator, Set<NodeParameter> parameters, int x, int y, int width, int height, boolean bypassed) {
        this(id, algorithmConfigurator.getAlgorithmName(), algorithmConfigurator.getAlgorithmVersionId(), parameters, x, y, width, height, bypassed, algorithmConfigurator.hasExitCode());
        this.setAlgorithmConfigurator(algorithmConfigurator);
        this.standardOutputFile = algorithmConfigurator.getStandardOutputFile();
        this.exitCodeLogFile = algorithmConfigurator.getExitCodeLogFile();
        this.warningsFile = algorithmConfigurator.getWarningsFile();
    }

    public FlowNode(int id, String algorithmName, AlgorithmVersionId algorithmVersionId, Set<NodeParameter> parameters, int x, int y, int width, int height, boolean bypassed, boolean hasExitCode) {
        this.setId(id);
        this.setAlgorithmName(algorithmName);
        this.setAlgorithmVersionId(algorithmVersionId);
        this.setParameters(parameters);
        this.setX(x);
        this.setY(y);
        this.setHeight(height);
        this.setWidth(width);
        this.setBypassed(bypassed);
        this.setHasExitCode(hasExitCode);
    }

    public void setStandardOutputFile(FileURLValue standardOutputFile) {
        this.standardOutputFile = standardOutputFile;
        if (null != this.algorithmConfigurator) {
            this.algorithmConfigurator.setStandardOutputFile(standardOutputFile);
        }
    }

    public FileURLValue getStandardOutputFile() {
        return this.standardOutputFile;
    }

    public FlowNode clone() {
        try {
            FlowNode clone = (FlowNode)super.clone();
            clone.algorithmVersionId = this.algorithmVersionId.clone();
            if (null != this.standardOutputFile) {
                clone.standardOutputFile = this.standardOutputFile.clone();
            }
            clone.parameters = new HashSet<NodeParameter>();
            for (NodeParameter nodeParameter : this.parameters) {
                clone.parameters.add(nodeParameter.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowNode other = (FlowNode)obj;
        return this.id == other.id;
    }

    public AlgorithmConfigurator getAlgorithmConfigurator() {
        return this.algorithmConfigurator;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public AlgorithmVersionId getAlgorithmVersionId() {
        return this.algorithmVersionId;
    }

    public int getHeight() {
        return this.height;
    }

    public int getId() {
        return this.id;
    }

    public NodeParameter getParameter(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterName"));
        }
        for (NodeParameter parameter : this.parameters) {
            if (!parameter.getName().equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    public Set<NodeParameter> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isBypassed() {
        return this.bypassed;
    }

    public boolean hasExitCode() {
        return this.hasExitCode && !this.isBypassed();
    }

    public FileURLValue getExitCodeLogFile() {
        if (this.isBypassed()) {
            return null;
        }
        return this.exitCodeLogFile;
    }

    public FileURLValue getWarningsFile() {
        if (this.isBypassed()) {
            return null;
        }
        return this.warningsFile;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("-> Identificador: " + this.getId() + "\n");
        builder.append("-> Algoritmo: " + this.getAlgorithmName() + "\n");
        builder.append("-> Vers\u00e3o:" + this.getAlgorithmVersionId() + "\n");
        builder.append("-> Configurador: " + this.getAlgorithmConfigurator() + "\n");
        builder.append("-> Par\u00e2metros:\n");
        builder.append("{\n");
        for (NodeParameter parameter : this.getParameters()) {
            builder.append("--> Nome:" + parameter.getName() + "\n");
            builder.append("--> R\u00f3tulo:" + parameter.getLabel() + "\n");
            builder.append("--> Tipo:" + parameter.getType() + "\n");
            builder.append("--> Valor:" + parameter.getValue() + "\n");
        }
        builder.append("}\n");
        builder.append("-> x: " + this.getX() + "\n");
        builder.append("-> y: " + this.getY() + "\n");
        builder.append("-> Largura: " + this.getWidth() + "\n");
        builder.append("-> Altura: " + this.getHeight() + "\n");
        builder.append("-> Bypassed: " + this.isBypassed() + "\n");
        return builder.toString();
    }

    private void setAlgorithmConfigurator(AlgorithmConfigurator algorithmConfigurator) {
        if (algorithmConfigurator == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "algorithmConfigurator"));
        }
        this.algorithmConfigurator = algorithmConfigurator;
    }

    private void setAlgorithmName(String algorithmName) {
        if (algorithmName == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "algorithmName"));
        }
        this.algorithmName = algorithmName;
    }

    private void setAlgorithmVersionId(AlgorithmVersionId algorithmVersionId) {
        if (algorithmVersionId == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "algorithmVersionId"));
        }
        this.algorithmVersionId = algorithmVersionId;
    }

    private void setHeight(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.positiveParameter"), "height", Integer.toString(height)));
        }
        this.height = height;
    }

    private void setId(int id) {
        this.id = id;
    }

    private void setParameters(Set<NodeParameter> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameters"));
        }
        this.parameters = new HashSet<NodeParameter>(parameters);
    }

    private void setWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.flows.FlowNode.positiveParameter"), "width", width));
        }
        this.width = width;
    }

    private void setX(int x) {
        this.x = x;
    }

    private void setY(int y) {
        this.y = y;
    }

    public void setBypassed(boolean bypassed) {
        this.bypassed = bypassed;
    }

    public void setHasExitCode(boolean hasExitCode) {
        this.hasExitCode = hasExitCode;
    }

    public void setExitCodeLogFile(FileURLValue exitCodeLogFile) {
        this.exitCodeLogFile = exitCodeLogFile;
        if (null != this.algorithmConfigurator) {
            this.algorithmConfigurator.setExitCodeLogFile(exitCodeLogFile);
        }
    }

    public void setWarningsFile(FileURLValue warningsFile) {
        this.warningsFile = warningsFile;
        if (null != this.algorithmConfigurator) {
            this.algorithmConfigurator.setWarningsFile(warningsFile);
        }
    }
}

