/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parsers.StringToEnumConverter;

public class URLProtocolConverter
implements StringToEnumConverter<URLProtocol> {
    @Override
    public URLProtocol valueOf(String value) throws ParseException {
        if (value != null) {
            String upperCaseString = value.toUpperCase().trim();
            for (URLProtocol location : URLProtocol.values()) {
                String[] possibleMatches;
                for (String possibleMatch : possibleMatches = this.getPossibleMatches(location)) {
                    if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                    return location;
                }
            }
        }
        String f = "N\u00e3o foi poss\u00edvel converter '%s' em um item da enumera\u00e7\u00e3o %s.";
        String msg = String.format(f, value, URLProtocol.class.getSimpleName());
        throw new ParseException(msg);
    }

    private String[] getPossibleMatches(URLProtocol value) {
        switch (value) {
            case PROJECT: {
                return new String[]{"project", "projeto"};
            }
            case LOCAL: {
                return new String[]{"local", "client", "cliente"};
            }
            case SGA: {
                return new String[]{"sga"};
            }
        }
        return new String[]{value.getType()};
    }
}

