/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public final class DoubleParameterValidator
extends SimpleParameterValidator<Double> {
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;

    public DoubleParameterValidator(boolean isOptional, Double maximum, boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded) {
        super(isOptional);
        this.setMaximum(maximum, isMaximumIncluded);
        this.setMinimum(minimum, isMinimumIncluded);
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    public void setMaximum(Double maximum, boolean isMaximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        this.isMaximumIncluded = maximum == null ? false : isMaximumIncluded;
        this.maximum = maximum;
    }

    public void setMinimum(Double minimum, boolean isMinimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        this.isMinimumIncluded = minimum == null ? false : isMinimumIncluded;
        this.minimum = minimum;
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, Double value, ValidationContext context) throws RemoteException {
        Validation validationResult = super.validateValue(parameter, value, context);
        if (!validationResult.isWellSucceded()) {
            return validationResult;
        }
        if (parameter.isEnabled() && parameter.isVisible() && value != null) {
            if (value.equals(Double.NaN)) {
                return new ValidationError(new LocalizedMessage(DoubleParameterValidator.class, "error_value", new Object[]{parameter.getLabel()}));
            }
            if (this.minimum != null) {
                if (this.isMinimumIncluded) {
                    if (value.compareTo(this.minimum) < 0) {
                        LocalizedMessage message = new LocalizedMessage(DoubleParameterValidator.class, "less_than_minimum", new Object[]{parameter.getLabel(), value, this.minimum});
                        return new ValidationError(message);
                    }
                } else if (value.compareTo(this.minimum) <= 0) {
                    LocalizedMessage message = new LocalizedMessage(DoubleParameterValidator.class, "less_or_equals_to_minimum", new Object[]{parameter.getLabel(), value, this.minimum});
                    return new ValidationError(message);
                }
            }
            if (this.maximum != null) {
                if (this.isMaximumIncluded) {
                    if (value.compareTo(this.maximum) > 0) {
                        LocalizedMessage message = new LocalizedMessage(DoubleParameterValidator.class, "larger_than_maximum", new Object[]{parameter.getLabel(), value, this.maximum});
                        return new ValidationError(message);
                    }
                } else if (value.compareTo(this.maximum) >= 0) {
                    LocalizedMessage message = new LocalizedMessage(DoubleParameterValidator.class, "larger_or_equals_to_maximum", new Object[]{parameter.getLabel(), value, this.maximum});
                    return new ValidationError(message);
                }
            }
        }
        return new ValidationSuccess();
    }
}

