/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

class OutputFileListParameterParser
extends AbstractFileParameterParser<OutputFileListParameter> {
    protected static final String OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE = "forcar_extensao";
    protected static final boolean OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_DEFAULT_VALUE = false;

    OutputFileListParameterParser() {
    }

    @Override
    public OutputFileListParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe;
        boolean pipeDefined = parser.hasAttributeValue("permitir_pipe");
        if (pipeDefined && ((usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter())) == FileParameterPipeAcceptance.TRUE || usesPipe == FileParameterPipeAcceptance.ALWAYS)) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NoPipesInputFile"));
        }
        if (types != null && types.length > 1) {
            throw new ParseException("Arquivo de sa\u00edda (sele\u00e7\u00e3o m\u00faltipla) n\u00e3o admite m\u00faltiplos tipos de arquivo");
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        ArrayList<FileURLValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.OutputFileInvalidAttribute"), "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new ArrayList<FileURLValue>();
            defaultValue.add(new FileURLValue(".", "DIRECTORY_TYPE"));
        }
        boolean mustForceExtension = parser.extractAttributeValueAsBoolean(OUTPUT_FILE_PARAMETER_ELEMENT_MUST_FORCE_EXTENSION_ATTRIBUTE, false);
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        OutputFileListParameter parameter = new OutputFileListParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, types, mode, mustSort, useFilter, mustForceExtension);
        return parameter;
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(OutputFileListParameter.class);
    }

    @Override
    protected boolean acceptBothCategory() {
        return false;
    }
}

