/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import java.util.Arrays;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public final class OutputFileParameter
extends FileParameter {
    public static final String TYPE = "OUTPUT_FILE";
    public static final String LOG_FILE_PARAMETER_NAME = "LOG_FILE";
    private boolean mustForceExtension;

    public OutputFileParameter(String name, String label, String description, FileURLValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String[] fileTypes, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean mustForceExtension, boolean usesFilter) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileTypes, mode, usesPipe, usesFilter, false);
        if (!mode.equals((Object)FileParameterMode.DIRECTORY) && !mode.equals((Object)FileParameterMode.REGULAR_FILE)) {
            String errorMessage = String.format(LNG.get((String)"csbase.logic.algorithms.parameters.UnsupportedMode"), new Object[]{mode, Arrays.asList(FileParameterMode.DIRECTORY, FileParameterMode.REGULAR_FILE)});
            throw new IllegalArgumentException(errorMessage);
        }
        if (fileTypes != null && fileTypes.length > 1) {
            String errorMessage = "Par\u00e2metro n\u00e3o aceita m\u00faltiplos tipos de arquivo associados.";
            throw new IllegalArgumentException(errorMessage);
        }
        this.mustForceExtension = mustForceExtension;
    }

    public static OutputFileParameter createLogFile(String commandLinePattern) {
        return new OutputFileParameter(LOG_FILE_PARAMETER_NAME, "Arquivo de Log", "Arquivo de Log", null, true, true, commandLinePattern, new String[]{"LOG"}, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.FALSE, false, false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean mustForceExtension() {
        return this.mustForceExtension;
    }

    public boolean isLogFile() {
        return this.getName().equals(LOG_FILE_PARAMETER_NAME);
    }

    @Override
    public boolean setValue(FileURLValue file) {
        this.checkExtension(file);
        return super.setValue(file);
    }

    private void checkExtension(FileURLValue file) {
        if (file != null && this.mustForceExtension()) {
            String filePath = file.getPath();
            String fileExtension = FileUtils.getFileExtension((String)filePath);
            String[] types = this.getFileTypes();
            if (types == null || types.length != 1) {
                return;
            }
            String type = types[0];
            ProjectFileType projectFileType = ProjectFileType.getFileType(type);
            if (projectFileType == null) {
                return;
            }
            List<String> extensions = projectFileType.getExtensions();
            if (extensions.isEmpty()) {
                return;
            }
            if (fileExtension == null || !extensions.contains(fileExtension)) {
                filePath = filePath + '.' + extensions.get(0);
                file.setPath(filePath);
            }
        }
    }

    @Override
    public boolean isOuput() {
        return true;
    }
}

