package csbase.logic.algorithms.parameters.triggers;

import java.text.MessageFormat;

import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import tecgraf.javautils.core.lng.LNG;

/**
 * Gatilho Trocar Mximo para Parmetros com Nmeros Inteiros: Modifica o valor
 * mximo para parmetro do tipo {@link IntegerParameter Inteiro} e
 * {@link IntegerListParameter Lista de Inteiros} quando a {@link Condition
 * condio} for aceita.
 * 
 * @author lmoreira
 */
public final class ChangeMaximumForIntegersTrigger extends
  Trigger<SimpleParameter<?>> {
  /**
   * Mximo ou {@code null} se ele no existir.
   */
  private Integer maximum;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param maximum O mximo (Aceita {@code null}).
   */
  public ChangeMaximumForIntegersTrigger(IntegerParameter parameter,
    Condition condition, Integer maximum) {
    super(parameter, condition);
    this.maximum = maximum;
  }

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param maximum O mximo (Aceita {@code null}).
   */
  public ChangeMaximumForIntegersTrigger(IntegerListParameter parameter,
    Condition condition, Integer maximum) {
    super(parameter, condition);
    this.maximum = maximum;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (!super.equals(obj)) {
      return false;
    }
    ChangeMaximumForIntegersTrigger trigger =
      (ChangeMaximumForIntegersTrigger) obj;
    if (this.maximum == null && trigger.maximum == null) {
      return true;
    }
    return (this.maximum != null && this.maximum.equals(trigger.maximum));
  }

  /**
   * Obtm o mximo.
   * 
   * @return O mximo ou {@code null} se ele no existir.
   */
  public Integer getMaximum() {
    return this.maximum;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    SimpleParameter<?> parameter = getParameter();
    if (parameter instanceof IntegerListParameter) {
      IntegerListParameter intListParameter = (IntegerListParameter) parameter;
      intListParameter.setMaximum(getMaximum());
    }
    else if (parameter instanceof IntegerParameter) {
      IntegerParameter intParameter = (IntegerParameter) parameter;
      intParameter.setMaximum(getMaximum());
    }
    else {
      throw new IllegalStateException(MessageFormat.format(
		  LNG.get("csbase.logic.algorithms.parameters.InvalidType"),
		  	new Object[] {parameter.getLabel(), "real", "lista_de_reais" }));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    // @todo Auto-generated method stub
  }
}
