package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;

/**
 * Classe abstrata que  base para todos os parsers de parmetros.
 * 
 * @author Tecgraf
 */
public abstract class ParameterParser {

  /**
   * <p>
   * O elemento {@value #COMMAND_LINE_PATTERN_ELEMENT}: define o formato da
   * linha de comando para um configurador de algoritmos, para um grupo ou para
   * um parmetro.
   * </p>
   * <p>
   *  elemento filho do configurador de algoritmos, de um grupo ou de um
   * parmetro.
   * </p>
   * <p>
   * O seu valor  opcional e  do tipo string.
   * </p>
   */
  static final String COMMAND_LINE_PATTERN_ELEMENT = "formato_no_comando";

  /**
   * Carrega o formato da linha de comando.
   * 
   * @param parser O analisador(No aceita {@code null}).
   * @param defaultCommandLinePattern Linha de comando padro do algoritmo.
   * 
   * @return O formato da linha de comando (Se o elemento
   *         {@link #COMMAND_LINE_PATTERN_ELEMENT} no existir, retornar
   *         defaultCommandLinePattern).
   * 
   * @throws ParseException Em caso de erro no XML.
   */
  protected String loadCommandLinePattern(XmlParser parser,
    String defaultCommandLinePattern) throws ParseException {
    if (!parser.goToFirstChild(COMMAND_LINE_PATTERN_ELEMENT)) {
      return defaultCommandLinePattern;
    }
    String commandLinePattern = parser.getElementValue(null);
    parser.checkAttributes();
    parser.checkChildElements();
    parser.goToParent();
    return commandLinePattern;
  }
}
