package csbase.logic.server;

/**
 * Representa um evento de modificao de {@link ServerInfo informaes de um
 * servidor} no repositrio.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class ServerInfoModifyEvent extends ServerInfoEvent {
  /** {@link ServerInfo} anterior  modificao. */
  private ServerInfo oldServerInfo;

  /** {@link ServerInfo} resultante da modificao. */
  private ServerInfo newServerInfo;

  /**
   * Cria um evento de modificao de um {@link ServerInfo}.
   * 
   * @param source A origem do evento (onde o evento foi gerado).
   * @param oldServerInfo O {@link ServerInfo} no estado anterior  modificao.
   * @param newServerInfo O {@link ServerInfo} no estado resultante da
   *        modificao.
   */
  public ServerInfoModifyEvent(Object source, ServerInfo oldServerInfo,
    ServerInfo newServerInfo) {
    super(ServerInfoEventType.MODIFY);
    this.oldServerInfo = oldServerInfo;
    this.newServerInfo = newServerInfo;
  }

  /**
   * Obtm o {@link ServerInfo} no estado anterior  modificao.
   *
   * @return O {@link ServerInfo} no estado anterior  modificao.
   */
  public ServerInfo getOldServerInfo() {
    return this.oldServerInfo;
  }

  /**
   * Obtm o {@link ServerInfo} no estado resultante da modificao.
   *
   * @return O {@link ServerInfo} no estado resultante da modificao.
   */
  public ServerInfo getNewServerInfo() {
    return this.newServerInfo;
  }
}
