/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class AbstractFileParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    protected static final String FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE = "ordenar";
    protected static final boolean FILE_PARAMETER_ELEMENT_MUST_SORT_DEFAULT_VALUE = true;
    protected static final String FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE = "permitir_pipe";
    protected static final FileParameterPipeAcceptance FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE = FileParameterPipeAcceptance.TRUE;
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_ATTRIBUTE = "categoria";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY = "diretorio";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_BOTH = "ambos";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE = "arquivo";
    protected static final String FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE = "usar_diretorio_raiz_como_padrao";
    protected static final boolean FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_DEFAULT_VALUE = false;
    protected static final String FILE_PARAMETER_ELEMENT_TYPE_ATTRIBUTE = "tipo";
    protected static final String FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE = "usar_filtro";
    protected static final boolean FILE_PARAMETER_ELEMENT_USE_FILTER_DEFAULT_VALUE = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ProjectFileType projectFileType;
        String[] types = parser.extractAttributeValueAsArray(FILE_PARAMETER_ELEMENT_TYPE_ATTRIBUTE, null);
        String modeName = parser.extractAttributeValue(FILE_PARAMETER_ELEMENT_CATEGORY_ATTRIBUTE, null);
        FileParameterMode mode = null;
        if (modeName == null) {
            if (types != null) {
                for (String type : types) {
                    projectFileType = ProjectFileType.getFileType(type);
                    if (projectFileType != null && projectFileType.isDirectory()) {
                        if (mode == null) {
                            mode = FileParameterMode.DIRECTORY;
                            continue;
                        }
                        if (mode == FileParameterMode.DIRECTORY) continue;
                        mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
                    } else {
                        if (mode == null) {
                            mode = FileParameterMode.REGULAR_FILE;
                            continue;
                        }
                        if (mode == FileParameterMode.REGULAR_FILE) continue;
                        mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
                    }
                    break;
                }
            } else {
                mode = FileParameterMode.REGULAR_FILE;
            }
        } else if (modeName.equals(FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY)) {
            mode = FileParameterMode.DIRECTORY;
        } else if (modeName.equals(FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE)) {
            mode = FileParameterMode.REGULAR_FILE;
        } else if (modeName.equals(FILE_PARAMETER_ELEMENT_CATEGORY_BOTH)) {
            if (!this.acceptBothCategory()) throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2}.", modeName, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY);
            mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        } else {
            if (!this.acceptBothCategory()) throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2}.", modeName, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY);
            throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2};{3}.", modeName, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE, FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY, FILE_PARAMETER_ELEMENT_CATEGORY_BOTH);
        }
        if (types != null) {
            for (String type : types) {
                projectFileType = ProjectFileType.getFileType(type);
                if (projectFileType != null && !projectFileType.isDirectory() && mode == FileParameterMode.DIRECTORY) {
                    throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 compat\u00edvel com o tipo informado {1}, pois o tipo \u00e9 aplicavel somente a arquivos.", modeName, type);
                }
                if (projectFileType == null || !projectFileType.isDirectory() || mode != FileParameterMode.REGULAR_FILE) continue;
                throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 compat\u00edvel com o tipo informado {1}, pois o tipo \u00e9 aplicavel somente a diret\u00f3rios.", modeName, type);
            }
            return this.createFileParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, types, mode);
        } else {
            types = new String[]{};
        }
        return this.createFileParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, types, mode);
    }

    protected abstract boolean acceptBothCategory();

    protected abstract T createFileParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, String[] var8, FileParameterMode var9) throws ParseException;

    protected class FileParameterPipeAcceptanceConverter
    implements StringToEnumConverter<FileParameterPipeAcceptance> {
        protected FileParameterPipeAcceptanceConverter() {
        }

        public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
            switch (value) {
                case TRUE: {
                    return XmlParser.TRUE_VALUES;
                }
                case FALSE: {
                    return XmlParser.FALSE_VALUES;
                }
                case ALWAYS: {
                    return new String[]{"sempre", "always"};
                }
            }
            throw new BugException();
        }

        @Override
        public FileParameterPipeAcceptance valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(mode)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return mode;
                    }
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de " + "enumera\u00e7\u00e3o do tipo " + FileParameterPipeAcceptance.class.getName());
        }
    }
}

