package csbase.exception;

/**
 * A classe <code>InitFailureException</code> representa uma falha
 * durante um procedimento de inicializao.
 */
public class InitFailureException extends CSBaseException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public InitFailureException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * @param message a descrio do erro
   */
  public InitFailureException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   * @param exception a exceo original
   */
  public InitFailureException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public InitFailureException(String message, Throwable exception) {
    super(message, exception);
  }
}
