/*
 * $Id:$
 */

package csbase.exception.algorithms;

import java.text.MessageFormat;
import java.util.Arrays;

import tecgraf.javautils.core.lng.LNG;
import csbase.exception.CSBaseException;

/**
 * Exceo de funo no encontrada em exceo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ExpressionFunctionNotFoundException extends CSBaseException {

  /**
   * Construtor
   * 
   * @param functionName nome da funo
   * @param parameterTypes tipos dos parmetros.
   */
  public ExpressionFunctionNotFoundException(String functionName,
    Class<?>... parameterTypes) {
    super(createMessage(functionName, parameterTypes));
  }

  /**
   * Montagem de texto de mensagem.
   * 
   * @param functionName nome da funo
   * @param parameterTypes tipos dos parmetros.
   * @return texto.
   */
  private static String createMessage(String functionName,
    Class<?>... parameterTypes) {
    return MessageFormat.format(
    		LNG.get("ExpressionFunctionNotFoundException"
    				+ ".error_parameter_function_not_found"),
      functionName, Arrays.asList(parameterTypes));
  }
}
